<?php
/* --------------------------------------------------------------
   CustomImageConfiguration.php 2023-01-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\ImageProcessing\Model\Configuration;

/**
 * Class CustomImageConfiguration
 *
 * @package Gambio\Admin\Modules\ImageProcessing\Model\Configuration
 */
class CustomImageConfiguration implements ImageConfiguration
{
    /**
     * CustomImageConfiguration constructor.
     *
     * @param string $source
     * @param string $destination
     * @param int    $width
     * @param int    $height
     */
    public function __construct(
        private string $source,
        private string $destination,
        private int    $width,
        private int    $height
    ) {
    }
    
    
    /**
     * @return string
     */
    public function path(): string
    {
        return $this->source;
    }
    
    
    /**
     * @return string
     */
    public function destination(): string
    {
        return $this->destination;
    }
    
    
    /**
     * @return int
     */
    public function width(): int
    {
        return $this->width;
    }
    
    
    /**
     * @return int
     */
    public function height(): int
    {
        return $this->height;
    }
}